c=======================================================================
c23456789012345678901234567890123456789012345678901234567890123456789012
c  all uppercase and detab  mar-07
c
c      cip1.inc
c
c   14.7.95:    4 tilts
c    5.9.95:    2 or 4 tilts   =>>  new cip.inc, new *.ctrl  !!!!!
c                              =>>  nevertheless: cip always reads 4 tilt images
c                    tilts=2  eup and sup,  tilts=4  eup, sup, wup and nup
c                    tilttype = option for tilt correction:
c                    (1) w/r to 180 image
c                  (2) internally calibrated (comparison of tilt images only)
c               fn_back1, fn_back2 background for rot and cirpol
c               back1, back2, flaresub   0=none 1=subtract
c
c      cip.inc is an include file which defines all variables
c      and sets all parameters that are necessary in the cip program
c      all modules of the cip program start with
c             implicit none
c             inlcude 'cip.inc'
c
c
c   30.5.96: polamp added
c   april 1998, brown: direct method for stretched cirpol input
c   april 1998, brown: inclusion of invpima to obtain 36*36 pole figure
c                      to go into nih image lazy pole (as for mentex)
c   may 1998, brown: misor images for n e and up
c
c   1/99 basel: added 2nd input calib: 1. scanner_lut  2. equip_lut
c                          1.= invert    2. = eos calibration/nih imagea
c   4/99 basel: new calibration:  1. program_lut (nih image = invert)
c                                 2. camera_lut  (eos calibration bh stack)
c                                 3. ampl_sine2_lut ((inverse) incl-of-brightness))
c                                 4. cirpol_sine2_lut (same: 0-255 bv -> 0-90 deg.)
c

c      input/output units

       integer in_unit,out_unit,ctrl_unit
       parameter (in_unit=5, out_unit=6,ctrl_unit=2)

c      size of 1-d internal image arrays

       integer n_maxsize
       parameter (n_maxsize = 1524*1012)  ! is not checked !!!

c     dimensions

       integer back2,back1,flaresub,camcorr
       integer xdim,ydim
       integer*4 itot
       integer tilttype,tilts
       integer aziref,incref,azins,incns,aziew,incew,azihh,inchh
c
c      input files   of rotation images
c      n_tilt        number of tilt images
c      1             one circular polarization image
c      2             two background file
c      xdim,ydim     x- and y- dimensions of images
c       tilts           how many tilts (2 or 4)
c       tilttype        type of correction
c       back1,back2    background corrections for 
c                       rotation and circular polarisation
c       flaresub        subtraction of flare
c
c      input images (the following convention is used)
c
c             pixrot (n_maxsize, 1) =  10 deg.
c             pixrot (n_maxsize, 2) =  20 deg.
c             ......
c             pixrot (n_maxsize,18) = 180 deg.
c
c             pixtilt (n_maxsize,1) = west  down = east up
c             pixtilt (n_maxsize,2) = north down = south up
c             pixtilt (n_maxsize,3) = east  down = west up
c             pixtilt (n_maxsize,4) = south down = north up


       integer n_rot,n_tilt
       parameter (n_rot = 18 , n_tilt = 4)

       integer e_up, s_up, w_up, n_up
       parameter(e_up=1, s_up=2, w_up=3, n_up=4)

       character*80 fn_rot(n_rot)
       character*80 fn_tilt(n_tilt)
       character*80 fn_cirpol
       character*80 fn_back1, fn_back2

       character*1 pixrot(n_maxsize,n_rot)
       character*1 pixtilt(n_maxsize,n_tilt)
       character*1 pixcirpol(n_maxsize)
       character*1 pixback1(n_maxsize),pixback2(n_maxsize)



c      primary result images

       integer n_curf
       parameter (n_curf = 5)
       character*80 fn_curfit(n_curf)

       character*1 pixcurfit(n_maxsize,n_curf)

       integer nr_maxval, nr_minval
       integer nr_maxphas, nr_minphas
       integer nr_ierr

       parameter (nr_maxval=1, nr_minval=2)
       parameter (nr_maxphas=3, nr_minphas=4)
       parameter (nr_ierr=5)



c      final result images

       integer n_resu
       parameter (n_resu = 9)
       character*80 fn_result(n_resu)

       character*1 pixresult(n_maxsize,n_resu)

       integer nr_azi, nr_incpol, nr_incamp
       integer nr_edge_pol,nr_edge_amp,nr_misn,nr_mise,nr_mish,nr_misr
       parameter (nr_azi=1, nr_incpol=2, nr_incamp=3)
       parameter (nr_edge_pol=4, nr_edge_amp=5)
       parameter (nr_misn=6, nr_mise=7, nr_mish=8, nr_misr=9)


c      pole figures

       integer n_stereo,nn_stereo
       parameter (n_stereo = 180, nn_stereo = 180*180)

c  fn_stereo(1) is square azi-inc matrix 180*180
c  fn_stereo(2) is square azi inc matrix 36*36 (=> upper left of (1))
c         cpf as in mentex for invpima
       
       character*80 fn_stereo(2)
       character*80 fn_cpf

       character*1 pixstereo(nn_stereo,2)
       

c      common block of ava and color lookup-tables (azi+inc)

       character*1 clut(3,n_stereo,n_stereo) , pixclut(3*nn_stereo)
       character*1 pixava(3*n_maxsize)
       character*80 fn_ava,fn_clut,fn_pixclut
       common/clut_common/clut,pixava,pixclut,fn_clut,
     . fn_ava,fn_pixclut,fn_cpf
       
c   clut     3 channels of 180*180 (square clut)  clut(3,inc,azi)
c   pixclut  linear file of clut                  pixclut(3*azi*inc)

       
c      calibration and control data       

       character*80 title

       integer lut_low, lut_up
       parameter (lut_low=0, lut_up=255)

       character*1 mineral

       character*80 fn_control
       character*80 fn_calib_input, fn_calib_inclination

       integer program_lut(lut_low:lut_up)
       integer camera_lut(lut_low:lut_up)
       integer ampl_sine2_lut(lut_low:lut_up)
       integer cirpol_sine2_lut(lut_low:lut_up)
       integer flare(n_rot)
       integer magenta
       integer polamp


c      common block of calibration

       common/calib_common1/title,mineral
       common/back_common/back1,back2,flaresub,camcorr
       common/pol_or_amp/polamp
       common/calib_common2/magenta,flare,program_lut,camera_lut,
     .                       ampl_sine2_lut,cirpol_sine2_lut



c      common blocks of file names and image matrices

       common/fn_common/fn_rot,fn_tilt,fn_cirpol,fn_back1,
     . fn_back2,fn_control, fn_calib_input, fn_calib_inclination,
     .  fn_curfit,fn_result,fn_stereo


       common/pix_common/xdim,ydim,itot,pixrot,pixtilt,pixcirpol,
     .            pixback1,pixback2,pixcurfit,pixresult,pixstereo

c       common block of misorientation reference directions
c       and tilt numbers and tilt types

       parameter (azins= 0,incns=90)
        parameter (aziew=90,incew=90)
        parameter (azihh= 0,inchh= 0)

       common/choices_common/tilts,tilttype,aziref,incref

